<?php

	if ( ! defined( 'ABSPATH' ) ) exit;

	class WC_Prdctfltr_Shortcodes_AJAX_Fix {
		function in_admin() {
			return false;
		}
	}

	class WC_Prdctfltr_Shortcodes {

		public static $settings;

		public static function init() {

			$class = __CLASS__;
			new $class;

		}

		function __construct() {

			add_shortcode( 'prdctfltr_sc_products', __CLASS__ . '::prdctfltr_sc_products_700' );
			add_shortcode( 'prdctfltr_sc_get_filter', __CLASS__ . '::prdctfltr_sc_get_filter' );
			add_action( 'woocommerce_before_subcategory', __CLASS__. '::add_category_support', 10, 1 );
			add_action( 'wp_ajax_nopriv_prdctfltr_respond_550', __CLASS__ . '::prdctfltr_respond_550' );
			add_action( 'wp_ajax_prdctfltr_respond_550', __CLASS__ . '::prdctfltr_respond_550' );

			$shortcodes = array(
				'products',
				'recent_products',
				'sale_products',
				'best_selling_products',
				'top_rated_products',
				'featured_products',
				'product_cat',
				'product_attribute'
			);

			foreach( $shortcodes as $shortcode ) {
				add_action( 'woocommerce_shortcode_before_' . $shortcode . '_loop', __CLASS__ . '::add_wcsc_filter', 10, 1 );
				add_action( 'woocommerce_shortcode_after_' . $shortcode . '_loop', __CLASS__ . '::after_wcsc_filter', 10, 1 );
				add_action( 'woocommerce_shortcode_' . $shortcode . '_loop_no_results', __CLASS__ . '::noresults_wcsc_filter', 10, 1 );
				if ( $shortcode == 'product_cat' ) {
					$shortcode = 'product_category';
				}
				add_filter( 'shortcode_atts_' . $shortcode, __CLASS__ . '::extend_atts', 10, 4 );
			}

		}

		public static function after_wcsc_filter( $atts ) {
			if ( !empty( $atts['prdctfltr'] ) ) {
				echo '</div>';

				remove_filter( 'loop_start', 'WC_Prdctfltr_Shortcodes::get_wp_query' );
				remove_filter( 'pre_get_posts', 'WC_Prdctfltr::sc_wc_query' );
				remove_filter( 'parse_tax_query', 'WC_Prdctfltr::sc_wc_tax' );
				remove_filter( 'woocommerce_shortcode_products_query', 'WC_Prdctfltr_Shortcodes::fix_wcsc_parameters', 9999, 3 );
				self::$settings['wcsc_products'] = null;
			}
		}

		public static function get_wp_query( $query ) {
			global $wp_query;
			if ( is_ajax() ) {
				$wp_query = $query;
			}

			if ( is_ajax() ) {
				$paged = self::$settings['opt']['pf_paged'];
			}
			else {
				$paged =  max( 1, $query->get( 'paged' ) );
			}

			$found = $query->found_posts;
			$per_page = $query->get( 'posts_per_page' ) == -1 ? $found : $query->get( 'posts_per_page' );

			WC_Prdctfltr::$settings['sc_instance'] = array(
				'paged'			=> $paged,
				'per_page'		=> $per_page,
				'total'			=> $found,
				'first'			=> ( $per_page * $paged ) - $per_page + 1,
				'last'			=> min( $found, $per_page * $paged ),
				'request'		=> $query->request
			);

			if ( self::$settings['wcsc_products'] == 'yes' && !is_ajax() ) {
				include( WC_Prdctfltr::$dir . 'templates/product-filter.php' );
				echo "<script class='prdctfltr-fix-wcsc'>
(function($){
'use strict';
	$('.prdctfltr_wcsc .products .prdctfltr_wc.prdctfltr_mobile').each(function(){
		var e = $(this).closest('.prdctfltr_wcsc');
		e.prepend($($(this).wrap('<div/>').parent().html()));
		$(this).parent().remove();
	});
	$('.prdctfltr_wcsc .products .prdctfltr_wc:not(.prdctfltr_mobile)').each(function(){
		var e = $(this).closest('.prdctfltr_wcsc');
		e.prepend($($(this).wrap('<div/>').parent().html()));
		$(this).parent().remove();
	});
	$('.prdctfltr-fix-wcsc:first').remove();

})(jQuery);
				</script>";
			}

		}

		public static function add_wcsc_filter( $atts ) {
			if ( !empty( $atts['prdctfltr'] ) ) {
				global $prdctfltr_global;

				$prdctfltr_global['unique_id'] = uniqid( 'prdctfltr-' );
				$prdctfltr_global['preset'] = ( isset( $atts['preset'] ) ? $atts['preset'] : '' );

				$prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['wcsc'] = true;
				$prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['loop_name'] = self::$settings['wcsc']['loop_name'];
				$prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['query_args'] = self::$settings['wcsc']['query_args'];
				$prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts'] = self::$settings['wcsc']['atts'];

				if ( !isset( self::$settings['sc'] ) ) {
					self::$settings['sc'] = $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']];
				}

				add_action( 'loop_start', 'WC_Prdctfltr_Shortcodes::get_wp_query' );

				echo '<div class="prdctfltr_sc prdctfltr_sc_products prdctfltr_wcsc' . ( isset( $atts['ajax'] ) ? ' prdctfltr_ajax' : '' ) . '">';

			}
		}

		public static function noresults_wcsc_filter( $atts ) {
			if ( !empty( $atts['prdctfltr'] ) ) {

				echo '<div class="prdctfltr_sc prdctfltr_sc_products prdctfltr_wcsc' . ( isset( $atts['ajax'] ) ? ' prdctfltr_ajax' : '' ) . '">';

				global $prdctfltr_global;
				$prdctfltr_global['preset'] = isset( $atts['preset'] ) && $atts['preset'] !== '' ? $atts['preset'] : null;
				WC_Prdctfltr::prdctfltr_get_settings();

				do_action( 'woocommerce_no_products_found' );

				echo '</div>';

			}
		}

		public static function fix_wcsc_parameters( $query_args, $atts, $loop_name ) {

			if ( !empty( $atts['prdctfltr'] ) ) {
				global $prdctfltr_global;

				self::$settings['wcsc']['query_args'] = $query_args;
				self::$settings['wcsc']['atts'] = $atts;
				self::$settings['wcsc']['loop_name'] = $loop_name == 'product_cat' ? 'product_category' : $loop_name;

				if ( isset( $prdctfltr_global['active_filters'] ) ) {
					$query_args['prdctfltr'] = $prdctfltr_global['active_filters'];
				}

				$query_args['no_found_rows'] = 0;
				if ( is_ajax() ) {
					$query_args['paged'] = self::$settings['opt']['pf_paged'];
				}

			}
			return $query_args;

		}

		public static function extend_atts( $out, $pairs, $atts, $shortcode ) {

			if ( !empty( $atts['prdctfltr'] ) && in_array( $atts['prdctfltr'], array( 'yes', 'widget' ) ) ) {
				$out['prdctfltr'] = $atts['prdctfltr'];
				self::$settings['wcsc_products'] = $atts['prdctfltr'];
				$out['ajax'] = isset( $atts['ajax'] ) && $atts['ajax'] == 'yes' ? 'yes' : null;
				$out['preset'] = isset( $atts['preset'] ) && $atts['preset'] !== '' ? $atts['preset'] : null;
				self::$settings['wcsc']['shortcode'] = $shortcode;

				if ( !is_ajax() ) {
					global $prdctfltr_global;
					if ( !isset( $prdctfltr_global['done_filters'] ) ) {
						WC_Prdctfltr::make_global( $_REQUEST, 'FALSE' );
					}
				}
				add_filter( 'pre_get_posts', 'WC_Prdctfltr::sc_wc_query' );
				add_filter( 'parse_tax_query', 'WC_Prdctfltr::sc_wc_tax' );

				add_filter( 'woocommerce_shortcode_products_query', 'WC_Prdctfltr_Shortcodes::fix_wcsc_parameters', 9999, 3 );

			}
			else {
				$atts['prdctfltr'] = null;
			}

			return $out;

		}

		public static function add_category_support( $category ) {

			echo '<span class="prdctfltr_cat_support" style="display:none!important;" data-slug="' . $category->slug . '"></span>';

		}

		public static function get_categories() {

			global $wp_query, $prdctfltr_global;

			$defaults = array(
				'before'        => '',
				'after'         => '',
				'force_display' => false
			);

			$args = array();

			$args = wp_parse_args( $args, $defaults );

			extract( $args );

			$selected_term = isset( $prdctfltr_global['active_filters']['product_cat'][0] ) ? $prdctfltr_global['active_filters']['product_cat'][0] : '';
			if ( $selected_term == '' ) {
				$selected_term = isset( $prdctfltr_global['active_permalinks']['product_cat'][0] ) ? $prdctfltr_global['active_permalinks']['product_cat'][0] : '';
			}

			if ( $selected_term !== '' ) {

				if ( term_exists( $selected_term, 'product_cat' ) ) {

					$term = get_term_by( 'slug', $selected_term, 'product_cat' );

				}

			}

			if ( !isset( $term ) ) {

				$term = (object) array( 'term_id' => 0 );

			}

			$parent_id = ( $term->term_id == 0 ? 0 : $term->term_id );

			$product_categories = get_categories( apply_filters( 'woocommerce_product_subcategories_args', array(
				'parent'       => $parent_id,
				'menu_order'   => 'ASC',
				'hide_empty'   => 0,
				'hierarchical' => 1,
				'taxonomy'     => 'product_cat',
				'pad_counts'   => 1
			) ) );

			if ( $product_categories ) {

				echo $before;

				foreach ( $product_categories as $category ) {
					wc_get_template( 'content-product_cat.php', array(
						'category' => $category
					) );
				}

				if ( $term->term_id !== 0 ) {

					$display_type = get_woocommerce_term_meta( $term->term_id, 'display_type', true );

					switch ( $display_type ) {

						case 'subcategories' :
							$wp_query->post_count    = 0;
							$wp_query->max_num_pages = 0;
						break;

						case '' :
						default :
							if ( get_option( 'woocommerce_category_archive_display' ) == 'subcategories' ) {
								$wp_query->post_count    = 0;
								$wp_query->max_num_pages = 0;
							}
						break;

					}

				}

				if ( $term->term_id == 0 && get_option( 'woocommerce_shop_page_display' ) == 'subcategories' ) {
					$wp_query->post_count    = 0;
					$wp_query->max_num_pages = 0;
				}

				echo $after;

				return true;

			}

		}

		public static function prdctfltr_sc_products_700( $atts, $content = null ) {

			$atts = shortcode_atts( array(
				'preset' => '',
				'rows' => 4,
				'columns' => 4,
				'cat_columns' => 4,
				'fallback_css' => 'no',
				'ajax' => 'no',
				'pagination' => 'yes',
				'use_filter' => 'yes',
				'show_categories' => 'no',
				'show_products' => 'yes',
				'min_price' => '',
				'max_price' => '',
				'orderby' => '',
				'order' => '',
				'product_cat'=> '',
				'product_tag'=> '',
				'product_characteristics'=> '',
				'operator' => 'IN',
				'sale_products' => '',
				'instock_products' => '',
				'http_query' => '',
				'disable_overrides' => 'yes',
				//'disable_woo_filter' => 'no',
				'action' => '',
				'show_loop_title' => '',
				'show_loop_price' => '',
				'show_loop_rating' => '',
				'show_loop_add_to_cart' => '',
				'bot_margin' => 36,
				'class' => '',
				'shortcode_id' => ''
			), $atts );

			if ( !isset( self::$settings['opt'] ) ) {

				$paged = isset( $_REQUEST['paged'] ) ? intval( $_REQUEST['paged'] ) : get_query_var( 'paged' );

				if ( $paged < 1 ) {
					$paged = 1;
				}

				$opt = array(
					'pf_request' => array(),
					'pf_requested' => array(),
					'pf_filters' => array(),
					'pf_widget_title' => null,
					'pf_set' => 'shortcode',
					'pf_paged' => $paged,
					'pf_pagefilters' => array(),
					'pf_shortcode' => '',
					'pf_offset' => 0,
					'pf_restrict' => '',
					'pf_adds' => array(),
					'pf_orderby_template' => null,
					'pf_count_template' => null
				);

				self::$settings['opt'] = $opt;
			}
			else {
				$paged = self::$settings['opt']['pf_paged'];
			}

			$ordering_args = WC()->query->get_catalog_ordering_args( $atts['orderby'], $atts['order'] );
			$meta_query    = WC()->query->get_meta_query();
			$query_args    = array(
				'post_type'           => 'product',
				'post_status'         => 'publish',
				'ignore_sticky_posts' => 1,
				'orderby'             => $ordering_args['orderby'],
				'order'               => $ordering_args['order'],
				'posts_per_page'      => $atts['columns']*$atts['rows'],
				'meta_query'          => $meta_query,
				'tax_query'           => WC()->query->get_tax_query(),
				'paged'               => $paged
			);

			$taxonomies = array_filter( array(
				'product_cat' => $atts['product_cat'],
				'product_tag' => $atts['product_tag'],
				'characteristics' => $atts['product_characteristics']
			) );

			$query_args = self::add_taxonomy_args( $query_args, $taxonomies, $atts['operator'] );

			if ( !empty( $atts['min_price'] ) ) {
				$query_args['min_price'] = $atts['min_price'];
			}

			if ( !empty( $atts['max_price'] ) ) {
				$query_args['max_price'] = $atts['max_price'];
			}

			if ( !empty( $atts['sale_products'] ) && $atts['sale_products'] == 'on' ) {
				$query_args['sale_products'] = 'on';
			}

			if ( !empty( $atts['instock_products'] ) && in_array( $atts['instock_products'], array( 'in', 'out', 'both' ) ) ) {
				self::$settings['sc_instock'] = $atts['instock_products'];
				$query_args['instock_products'] = $atts['instock_products'];
			}

			if ( !empty( $atts['http_query'] ) ) {
				parse_str( html_entity_decode( $atts['http_query'] ), $httpQuery );
				$query_args = array_merge( $query_args, $httpQuery );
			}

			if ( isset( $ordering_args['meta_key'] ) ) {
				$query_args['meta_key'] = $ordering_args['meta_key'];
			}

			global $prdctfltr_global;

			if ( !is_ajax() && !isset( $prdctfltr_global['done_filters'] ) ) {
				WC_Prdctfltr::make_global( $_REQUEST, 'FALSE' );
				if ( isset( self::$settings['sc_instock'] ) ) {
					unset( self::$settings['sc_instock'] );
				}
			}

			$prdctfltr_global['sc_init'] = true;
			$prdctfltr_global['sc_products'] = true;
			$prdctfltr_global['unique_id'] = uniqid( 'prdctfltr-' );
			$prdctfltr_global['action'] = ( $atts['action'] !== '' ? $atts['action'] : '' );
			$prdctfltr_global['preset'] = ( $atts['preset'] !== '' ? $atts['preset'] : '' );
			$prdctfltr_global['disable_overrides'] = ( $atts['disable_overrides'] == 'yes' ? 'yes' : 'no' );

			if ( $atts['show_categories'] == 'yes' && $atts['ajax'] == 'yes' ) {
				$prdctfltr_global['categories_active'] = true;
			}




			if ( $atts['ajax'] == 'yes' ) {
				$add_ajax = ' data-page="' . $paged . '"';
			}

			$prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['sc'] = true;
			$prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['query_args'] = $query_args;
			$prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts'] = $atts;
			$prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts']['per_page'] = $atts['columns'] * $atts['rows'];

			if ( $atts['show_products'] == 'no' ) {
				WC_Prdctfltr::$settings['instance']['step_filter'] = true;
				$prdctfltr_global['step_filter'] = true;
			}
			else {
				if ( !isset( self::$settings['sc'] ) ) {
					self::$settings['sc'] = $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']];
				}
			}

			$query = self::make_query_700();

			if ( is_ajax() ) {
				global $wp_query;
				$wp_query = $query;
			}

			$cached = '';
			if ( !is_ajax() && $atts['use_filter'] == 'yes' ) {
				ob_start();
				include( WC_Prdctfltr::$dir . 'templates/product-filter.php' );
				$cached = ob_get_clean();
			}

			$cache_products = '';
			$cache_pagination = '';
			if ( $atts['show_products'] !== 'no' ) {
				$cache_products = self::get_products( $query );
				$pagination_args = array(
					'sc' => 'yes',
					'ajax' => $atts['ajax'],
					'type' => $atts['pagination']
				);
				if ( is_ajax() ) {
					self::$settings['paginationExport'] = self::get_pagination( $pagination_args );
				}
				else {
					$cache_pagination = self::get_pagination( $pagination_args );
				}
			}

		if ( !is_ajax() ) {
			wp_reset_query();
			wp_reset_postdata();
			$prdctfltr_global['unique_id'] = null;
			$prdctfltr_global['sc_init'] = null;
			$prdctfltr_global['sc_products'] = null;
			$prdctfltr_global['step_filter'] = null;
			$prdctfltr_global['preset'] = null;
			$prdctfltr_global['action'] = null;
			WC_Prdctfltr::$settings['maxheight'] = null;
		}


			$bot_margin = ( int ) $atts['bot_margin'];
			$margin = " style='margin-bottom:" . $bot_margin . "px'";

			return '<div' . ( $atts['shortcode_id'] !== '' ? ' id="' . $atts['shortcode_id'] .'"' : '' ) . ' class="prdctfltr_sc prdctfltr_sc_products woocommerce ' . 'columns-' . $atts['columns'] . ( $atts['ajax'] == 'yes' ? ' prdctfltr_ajax' : '' ) . ( $atts['fallback_css'] == 'yes' ? ' prdctfltr_fallback_css prdctfltr_columns_fallback_' . $atts['columns'] : '' ) . ( $atts['class'] !== '' ? ' ' . $atts['class'] : '' ) . '"' . $margin . ( $atts['ajax'] == 'yes' ? $add_ajax : '' ) . '>' . do_shortcode( $cached . $cache_products . $cache_pagination ) . '</div>';

		}

		public static function add_taxonomy_args( $args, $taxonomies, $operator ) {
			if ( ! empty( $taxonomies ) ) {
				foreach( $taxonomies as $taxonomy => $terms ) {
					if ( empty( $args['tax_query'] ) ) {
						$args['tax_query'] = array();
					}
					$args['tax_query'][] = array(
						array(
							'taxonomy' => $taxonomy,
							'terms'    => array_map( 'sanitize_title', explode( ',', $terms ) ),
							'field'    => 'slug',
							'operator' => $operator,
						),
					);
				}

			}

			return $args;
		}

		public static function prdctfltr_respond_550() {

			if ( !is_array( $_POST ) ) {
				die(0);
				exit;
			}

			$set = array(
				'pf_request' => array(),
				'pf_requested' => array(),
				'pf_filters' => array(),
				'pf_widget_title' => null,
				'pf_set' => 'shortcode',
				'pf_paged' => '',
				'pf_pagefilters' => array(),
				'pf_shortcode' => null,
				'pf_offset' => 0,
				'pf_restrict' => '',
				'pf_adds' => array(),
				'pf_orderby_template' => null,
				'pf_count_template' => null,
				'pf_url' => '',
				'pf_step' => 0,
				'pf_active' => null
			);

			$opt = array();

			foreach( $set as $k => $v ) {
				if ( isset( $_POST[$k] ) && $_POST[$k] !== '' ) {
					$opt[$k] = $_POST[$k];
				}
				else {
					$opt[$k] = $v;
				}
			}

			self::$settings['opt'] = $opt;

			$pf_request = isset( $opt['pf_request'] ) ? $opt['pf_request'] : array();
			$pf_requested = isset( $opt['pf_requested'] ) ? $opt['pf_requested'] : array();

			if ( empty( $pf_request ) || empty( $pf_requested ) ) {
				die(0);
				exit;
			}

			global $prdctfltr_global;
			$prdctfltr_global['pagefilters'] = $opt['pf_pagefilters'];
			$prdctfltr_global['unique_id'] = key( $pf_requested );

			$active_filters = isset( $opt['pf_filters'] ) && is_array( $opt['pf_filters'] ) ? $opt['pf_filters'] : array();

			$curr_filters = array();

			foreach ( $active_filters as $k => $v ) {
				$curr_filters = array_merge( $curr_filters, array_unique( $v, SORT_REGULAR ) );
			}
			WC_Prdctfltr::make_global( $curr_filters, 'AJAX' );

			if ( $opt['pf_set'] == 'shortcode' ) {

				if ( isset( $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['wcsc'] ) ) {

					$prdctfltr_global['sc_init'] = true;
					$prdctfltr_global['sc_query'] = $opt['pf_shortcode'];

					if ( isset( $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts'] ) ) {
						extract( $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts'] );
					}
					else if ( is_array( $prdctfltr_global['pagefilters'] ) ) {
						$pf_pagefilters = $prdctfltr_global['pagefilters'];
						reset( $pf_pagefilters );
						extract( $prdctfltr_global['pagefilters'][key( $pf_pagefilters )]['atts'] );
					}

					//$use_filter = 'yes';

				}
				else {

					$prdctfltr_global['sc_init'] = true;
					$prdctfltr_global['sc_query'] = $opt['pf_shortcode'];

					if ( isset( $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts'] ) ) {
						extract( $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts'] );
					}
					else if ( is_array( $prdctfltr_global['pagefilters'] ) ) {
						$pf_pagefilters = $prdctfltr_global['pagefilters'];
						reset( $pf_pagefilters );
						extract( $prdctfltr_global['pagefilters'][key( $pf_pagefilters )]['atts'] );
					}

				}

			}
			else {

				$permalink_taxonomies = array();
				$permalink_taxonomies_data = array();

				foreach( $opt['pf_adds'] as $k => $v ) {

					if ( strpos( $v, ',' ) ) {
						$pf_helper = explode( ',', $v );
						$permalink_taxonomies_data[$k.'_relation'] = 'IN';
					}
					else if ( strpos( $v, '+' ) ) {
						$pf_helper = explode( '+', $v );
						$permalink_taxonomies_data[$k.'_relation'] = 'AND';
					}
					else if ( strpos( $v, ' ' ) ) {
						$pf_helper = explode( ' ', $v );
						$permalink_taxonomies_data[$k.'_relation'] = 'AND';
					}
					else {
						$pf_helper = array( $v );
						$permalink_taxonomies_data[$k.'_relation'] = 'IN';
					}

					foreach( $pf_helper as $val ) {
						if ( term_exists( $val, $k ) !== null ) {
							$pf_helper_real[] = $val;
						}
					}

					if ( !empty( $pf_helper_real ) ) {
						if ( isset( $permalink_taxonomies_data[$k . '_relation'] ) && $permalink_taxonomies_data[$k . '_relation'] == 'AND' ){
							$permalink_taxonomies_data[$k . '_string'] = implode( '+', $pf_helper_real );
						}
						else {
							$permalink_taxonomies_data[$k . '_string'] = implode( ',', $pf_helper_real );
						}
						$permalink_taxonomies[$k] = $permalink_taxonomies_data[$k . '_string'];
					}


					$prdctfltr_global['permalinks_data'] = $permalink_taxonomies_data;
					$prdctfltr_global['sc_query'] = $prdctfltr_global['active_permalinks'] = $permalink_taxonomies;

				}

				$pagination_args = array();
				//$use_filter = 'yes';

			}

			$data = array();

			$atts = array();
			if ( self::$settings['opt']['pf_step'] == 0 && isset( $opt['pf_active'] ) ) {
				$atts = $opt['pf_active'];
			}
			else {
				$atts = $prdctfltr_global['pagefilters'][key( $pf_requested )];
			}

			if ( isset( $atts['wcsc'] ) ) {

				$data['query'] = self::get_query_string( $curr_filters );
				$data['products'] = call_user_func( 'WC_Shortcodes::' . $atts['loop_name'], $atts['atts'] );

				global $wp_query;
				$query = $wp_query;

			}

			else if ( isset( $atts['sc'] ) ) {

				$data['query'] = self::get_query_string( $curr_filters );
				$data['products'] = call_user_func( 'WC_Prdctfltr_Shortcodes::prdctfltr_sc_products_700', $atts['atts'] );
				if ( isset( self::$settings['paginationExport'] ) ) {
					$data['pagination'] = self::$settings['paginationExport'];
				}

				global $wp_query;
				$query = $wp_query;

			}

			else if ( isset( $atts['archive'] ) ) {

				$query = self::make_query_700();
				global $wp_query;
				$wp_query = $query;
				$data['query'] = self::get_query_string( $curr_filters );
				$data['products'] = self::get_products( $query );
				$data['pagination'] = self::get_pagination( $pagination_args );

			}

			foreach( $pf_request as $filter => $options ) {

				if ( in_array( $filter, $pf_requested ) ) {

					ob_start();

					$prdctfltr_global['unique_id'] = $filter;

					if ( $options['widget_search'] !== 'yes' ) {
						if ( isset( $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts']['preset'] ) && $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts']['preset'] !== '' ) {
							$prdctfltr_global['preset'] = $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts']['preset'];
						}
						include( WC_Prdctfltr::$dir . 'templates/product-filter.php' );
					}
					else {

						$widgetOptions = $options['widget_options'];

						if ( isset( $widgetOptions['preset'] ) && $widgetOptions['preset'] !== '' ) {
							$prdctfltr_global['preset'] = $widgetOptions['preset'];
						}

						$defaults = array(
							'style' => 'pf_default',
							'preset' => '',
							'disable_overrides' => 'no',
							'action' => ''
						);

						foreach( $defaults as $k => $v ) {
							if ( !isset( $widgetOptions[$k] ) ) {
								$widgetOptions[$k] = $v;
							}
						}

						$curr_title = array(
							'<h3>',
							'</h3>'
						);

						if ( isset( $opt['pf_widget_title'] ) ) {
							$curr_title = explode( '%%%', $opt['pf_widget_title'] );
						}

						the_widget( 'prdctfltr', 'preset=' . $widgetOptions['style'] . '&template=' . $widgetOptions['preset'] . '&disable_overrides=' . $widgetOptions['disable_overrides'], array( 'before_title' => stripslashes( $curr_title[0] ), 'after_title' => stripslashes( $curr_title[1] ) ) );

					}

					$data[$filter] = ob_get_clean();

				}

			}

			if ( $opt['pf_step'] == 0 ) {

				if ( isset( $opt['pf_count_template'] ) ) {

					if ( $wp_query->found_posts > 0 ) {
						ob_start();
						woocommerce_result_count();
						$data['count'] = ob_get_clean();
					}
					else {
						$data['count'] = '';
					}

				}

				if ( 1==1 ) {

					if ( get_query_var( 'paged' ) < 2 ) {
						$wp_query->set( 'paged', 0 );
					}
					$data['title'] = self::get_title();
					$data['description'] = self::get_description();

				}

				if ( isset( $opt['pf_orderby_template'] ) ) {

					if ( !isset( $_GET['orderby'] ) && isset( $prdctfltr_global['active_filters']['orderby'] ) ) {
						$_GET['orderby'] = $prdctfltr_global['active_filters']['orderby'];
					}
					else if ( !isset( $_GET['orderby'] ) ) {
						$orderby  = WC_Prdctfltr::get_catalog_ordering_args();
						$_GET['orderby'] = $orderby;
					}

					if ( isset( $_GET['orderby'] ) ) {
						$orderby = $_GET['orderby'];
						$wp_query->found_posts = 2;
						ob_start();
						woocommerce_catalog_ordering();
						$data['orderby'] = ob_get_clean();
					}

				}

			}

			if ( isset( $prdctfltr_global['ranges'] ) ) {
				$data['ranges'] = $prdctfltr_global['ranges'];
			}

			wp_send_json($data);
			exit;

		}

		public static function get_query_string( $curr_filters ) {

			$opt = self::$settings['opt'];

			if ( $opt['pf_step'] !== 0 ) {
				return '';
			}

			global $wp_rewrite;

			$redirect = trailingslashit( preg_replace( '%\/page/[0-9]+%', '', esc_url( $opt['pf_url'] ) ) );

			if ( strpos( $redirect, '?' ) > 0 ) {
				$redirect = explode( '?', $redirect );
				$redirect = $redirect[0];
			}

			$_SERVER['REQUEST_URI'] = str_replace( get_bloginfo( 'url' ), '', trailingslashit( $redirect ) );

			$filter_query_before = untrailingslashit( $redirect );
			if ( $opt['pf_paged'] > 1 ) {
				global $paged;
				$paged = $opt['pf_paged'];
				if ( WC_Prdctfltr::$settings['permalink_structure'] == '' ) {
					$filter_query_before = untrailingslashit( $redirect ) . '/' . '?paged=' . $opt['pf_paged'];
				}
				else {
					$filter_query_before = untrailingslashit( $redirect ) . '/' . $wp_rewrite->pagination_base . '/' . $opt['pf_paged'];
				}
			}

			foreach ( $curr_filters as $cfk => $cfv ) {
				if ( !isset( $filter_query ) ) {
					$filter_query = '/?' . $cfk . '=' . $cfv;
				}
				else {
					$filter_query .= '&' . $cfk . '=' . $cfv;
				}
			}

			if ( $opt['pf_set'] == 'shortcode' ) {
				return isset( $filter_query ) ? $filter_query_before . $filter_query : trailingslashit( $filter_query_before );
			}

			if ( WC_Prdctfltr::$settings['permalink_structure'] !== '' ) {

				global $wp_query;

				$current = $wp_query->get_queried_object();

				if ( isset( $current->taxonomy ) && isset( $curr_filters[$current->taxonomy] ) ) {

					$rewrite = $wp_rewrite->get_extra_permastruct( $current->taxonomy );

					if ( $rewrite !== false ) {

						if ( strpos( $curr_filters[$current->taxonomy], ',' ) || strpos( $curr_filters[$current->taxonomy], '+' ) || strpos( $curr_filters[$current->taxonomy], ' ' ) ) {
							if ( strpos( $curr_filters[$current->taxonomy], ',' ) ) {
								$terms = explode( ',', $curr_filters[$current->taxonomy] );
							}
							else if ( strpos( $curr_filters[$current->taxonomy], '+' ) ) {
								$terms = explode( '+', $curr_filters[$current->taxonomy] );
							}
							else if ( strpos( $curr_filters[$current->taxonomy], ' ' ) ) {
								$terms = explode( ' ', $curr_filters[$current->taxonomy] );
							}

							foreach( $terms as $term ) {
								$checked = get_term_by( 'slug', $term, $current->taxonomy );
								if ( !is_wp_error( $checked ) ) {
									/*if ( $checked->parent !== 0 ) {*/
										$parents[] = $checked->parent;
									/*}*/
								}
							}

							$parent_slug = '';
							if ( isset( $parents ) ) {
								$parents_unique = array_unique( $parents );
								if ( count( $parents_unique ) == 1 && $parents_unique[0] !== 0 ) {
									$not_found = false;
									$parent_check = $parents_unique[0];
									while ( $not_found === false ) {
										if ( $parent_check !== 0 ) {
											$checked = get_term_by( 'id', $parent_check, $current->taxonomy );
											if ( !is_wp_error( $checked ) ) {
												$get_parent = $checked->slug;
												$parent_slug =  $get_parent . '/' . $parent_slug;
												if ( $checked->parent !== 0 ) {
													$parent_check = $checked->parent;
												}
												else {
													$not_found = true;
												}
											}
											else {
												$not_found = true;
											}
										}
										else {
											$not_found = true;
										}
									}

								}
							}

							$redirect = untrailingslashit( preg_replace( '/\?.*/', '', get_bloginfo( 'url' ) ) ) . '/' . str_replace( '%' . $current->taxonomy . '%', $parent_slug . $curr_filters[$current->taxonomy], $rewrite );
						}
						else {
							$link = get_term_link( $curr_filters[$current->taxonomy], $current->taxonomy );
							if ( !is_wp_error( $link ) ) {
								$redirect = preg_replace( '/\?.*/', '', $link );
							}
						}

						unset( $curr_filters[$current->taxonomy] );

					}
					else {

						$redirect = get_permalink( WC_Prdctfltr::prdctfltr_wpml_get_id( wc_get_page_id( 'shop' ) ) );

					}

					if ( strpos( $redirect, '?' ) > 0 ) {
						$redirect = explode( '?', $redirect );
						$redirect = $redirect[0];
					}

					$redirect = untrailingslashit( $redirect );

					$_SERVER['REQUEST_URI'] = str_replace( get_bloginfo( 'url' ), '', trailingslashit( $redirect ) );

					if ( $opt['pf_paged'] > 1 ) {
						$redirect = $redirect . '/' . $wp_rewrite->pagination_base . '/' . $opt['pf_paged'];
					}

					if ( !empty( $curr_filters ) ) {

						$req = '';

						foreach( $curr_filters as $k => $v ) {
							if ( $v == '' || in_array( $k, apply_filters('prdctfltr_block_request', array( 'woocs_order_emails_is_sending' ) ) ) ) {
								continue;
							}

							$req .= $k . '=' . $v . '&';
						}

						$redirect = $redirect . '/?' . $req;

						if ( substr( $redirect, -1 ) == '&' ) {
							$redirect = substr( $redirect, 0, -1 );
						}

					}
					else {
						$redirect = trailingslashit( $redirect );
					}

					return $redirect;

				}
				else {

					$redirect = get_permalink( WC_Prdctfltr::prdctfltr_wpml_get_id( wc_get_page_id( 'shop' ) ) );

					if ( strpos( $redirect, '?' ) > 0 ) {
						$redirect = explode( '?', $redirect );
						$redirect = $redirect[0];
					}


					$redirect = untrailingslashit( $redirect );

					$_SERVER['REQUEST_URI'] = str_replace( get_bloginfo( 'url' ), '', trailingslashit( $redirect ) );

					if ( $opt['pf_paged'] > 1 ) {
						$redirect = $redirect . '/' . $wp_rewrite->pagination_base . '/' . $opt['pf_paged'];
					}

					if ( !empty( $curr_filters ) ) {

						$req = '';

						foreach( $curr_filters as $k => $v ) {
							if ( $v == '' || in_array( $k, apply_filters('prdctfltr_block_request', array( 'woocs_order_emails_is_sending' ) ) ) ) {
								continue;
							}

							$req .= $k . '=' . $v . '&';
						}

						$redirect = $redirect . '/?' . $req;

						if ( substr( $redirect, -1 ) == '&' ) {
							$redirect = substr( $redirect, 0, -1 );
						}

					}
					else {
						$redirect = trailingslashit( $redirect );
					}

					return $redirect;
				}

			}

		}

		public static function get_title() {
			$out = '';
			if ( function_exists( 'woocommerce_page_title' ) ) {
				ob_start();
			?>
				<h1 class="page-title"><?php woocommerce_page_title(); ?></h1>
			<?php
				$out .= ob_get_clean();
			}
			return $out;
		}

		public static function get_description() {
			$out = '';
			global $wp_query;

			if ( function_exists( 'woocommerce_taxonomy_archive_description' ) ) {
				ob_start();
				woocommerce_taxonomy_archive_description();
				$out .= ob_get_clean();
			}
			if ( $out == '' && function_exists( 'woocommerce_product_archive_description' ) ) {
				ob_start();
				woocommerce_product_archive_description();
				$out .= ob_get_clean();
			}
			return $out;
		}

		public static function add_product_class( $classes ) {
			global $post;

			if ( !in_array( $post->post_type, $classes ) ) {
				$classes[] = $post->post_type;
			}

			return $classes;
		}


		public static function make_query_700() {

			global $prdctfltr_global;

			$opt = self::$settings['opt'];

			add_filter( 'post_class', __CLASS__ . '::add_product_class' );

			$per_page = apply_filters( 'loop_shop_per_page', get_option( 'posts_per_page' ) );
			$columns = apply_filters( 'loop_shop_columns', 4 );

			if ( isset( $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['sc'] )) {
				$per_page = $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts']['per_page'];
				$columns = $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts']['columns'];
			}
			if ( isset( $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['archive'] )) {
				$per_page = $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts']['per_page'];
				$columns = $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts']['columns'];
			}
			if ( isset( $prdctfltr_global['active_filters']['products_per_page'] ) ) {
				$per_page = $prdctfltr_global['active_filters']['products_per_page'];
			}

			$query_args = $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['query_args'];

			self::$settings['columns'] = $columns;

			add_filter( 'pre_get_posts', 'WC_Prdctfltr::sc_wc_query', 999999, 1 );
			add_filter( 'parse_tax_query', 'WC_Prdctfltr::sc_wc_tax', 999999, 1 );

			$query_args['paged'] = $opt['pf_paged'];
			$query_args['posts_per_page'] = intval( $per_page );
			$query_args['no_found_rows'] = 0;
			$offset = intval( $opt['pf_offset'] );
			if ( $offset>0 ) {
				$query_args['offset'] = $offset;
			}

			$products = new WP_Query( $query_args );

			$products->is_search = false;

			WC_Prdctfltr::$settings['sc_instance'] = array(
				'paged'			=> $opt['pf_paged'],
				'per_page'		=> $per_page,
				'total'			=> $products->found_posts,
				'first'			=> ( $per_page * $opt['pf_paged'] ) - $per_page + 1,
				'last'			=> $offset > 0 ? min( $products->found_posts, $offset + $per_page ) : min( $products->found_posts, $per_page * $opt['pf_paged'] ),
				'request'		=> $products->request
			);

			global $paged;
			$paged = $opt['pf_paged'];

			return $products;

		}

		public static function get_pagination( $pagination ) {

			if ( isset( $pagination['type'] ) && $pagination['type'] == 'no' ) {
				return;
			}

			if ( !isset( self::$settings['wcsc'] ) ) {
				if ( !isset( self::$settings['instance'] ) ) {
					return;
				}
			}

			if ( ( $custom_pagination = WC_Prdctfltr::$settings['wc_settings_prdctfltr_ajax_pagination'] ) !== '' ) {
				if ( function_exists( $custom_pagination ) ) {
					ob_start();
					call_user_func( $custom_pagination );
					$html = ob_get_clean();
					if ( $html == '' ) {
						$html = call_user_func( $custom_pagination );
					}
					return $html;
				}
			}

			global $prdctfltr_global;

			if ( is_ajax() ) {
				//$_SERVER['REQUEST_URI'] = '/testing/shop/';
				$GLOBALS['current_screen'] = new WC_Prdctfltr_Shortcodes_AJAX_Fix;
			}

			if ( isset( $pagination['sc'] ) ) {

				$ajax = $pagination['ajax'];
				$type = $pagination['type'];

				if ( $ajax == 'yes' ) {
					switch ( $type ) {
						case 'yes' :
							$class = 'default';
						break;
						case 'override' :
							$class = 'prdctfltr-pagination-default';
						break;
						case 'loadmore' :
							$class = 'prdctfltr-pagination-load-more';
						break;
						default :
							$class = 'default';
						break;
					}
				}
				else {
					$class = 'default';
				}

				$prdctfltr_global['pagination_type'] = $class;

				global $wp_query, $wp_the_query;
				$remember_query = $wp_query;
				$wp_query = self::$settings['instance'];

				ob_start();
				if ( $prdctfltr_global['pagination_type'] == 'default' ) {
					wc_get_template( 'loop/pagination.php' );
				}
				else {
					WC_Prdctfltr::$settings['template'] = 'loop/pagination.php';
					include( WC_Prdctfltr::$dir . 'templates/getright.php' );
				}
				$pagination = ob_get_clean();

				$wp_query = $remember_query;
			}
			else {
				$ajax = 'yes';
				$prdctfltr_global['pagination_type'] = WC_Prdctfltr::$settings['wc_settings_prdctfltr_pagination_type'];

				ob_start();
				wc_get_template( 'loop/pagination.php' );
				$pagination = ob_get_clean();
			}

			unset( $prdctfltr_global['pagination_type'] );

			return $pagination;

		}

		public static function get_products( $products ) {

			global $prdctfltr_global, $woocommerce_loop;

			$opt = self::$settings['opt'];

			$offset = intval( $opt['pf_offset'] );

			$loop_elements = array();

			if ( isset( $opt['pf_active_sc'] ) && isset( $prdctfltr_global['pagefilters'][$opt['pf_active_sc']]['atts'] ) ) {
				extract( $prdctfltr_global['pagefilters'][$opt['pf_active_sc']]['atts'] );

				$check_elements = array(
					'title' => $show_loop_title,
					'price' => $show_loop_price,
					'rating' => $show_loop_rating,
					'add_to_cart' => $show_loop_add_to_cart
				);

				foreach( $check_elements as $k => $v ) {
					if ( !empty( $v ) && $v == 'no' ) {
						$loop_elements[] = $k;
					}
				}

			}
			else if ( isset( $prdctfltr_global['unique_id'] ) && isset( $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts']['show_products'] ) ) {

				extract( $prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts'] );

				$check_elements = array(
					'title' => $show_loop_title,
					'price' => $show_loop_price,
					'rating' => $show_loop_rating,
					'add_to_cart' => $show_loop_add_to_cart
				);

				foreach( $check_elements as $k => $v ) {
					if ( !empty( $v ) && $v == 'no' ) {
						$loop_elements[] = $k;
					}
				}

			}
			else {
				$show_categories = 'archive';
				$cat_columns = '';
				$show_products = 'yes';
			}

			if ( $show_products == 'no' ) {
				return;
			}

			ob_start();

			self::$settings['instance'] = $products;

			$woocommerce_loop['columns'] = self::$settings['columns'];

			if ( $products->have_posts() ) {
				if ( !empty( $loop_elements ) ) {
					self::make_visibility( 'remove', $loop_elements );
				}

				woocommerce_product_loop_start();

				if ( isset( $prdctfltr_global['categories_active'] ) && $prdctfltr_global['categories_active'] === true ) {

					if ( $show_categories == 'archive' ) {
						if ( isset( $cat_columns ) ) {
							$woocommerce_loop['columns'] = intval( $cat_columns );
						}
						woocommerce_product_subcategories();
					}
					else if ( $show_categories == 'yes' ) {

						if ( isset( $cat_columns ) ) {
							$woocommerce_loop['columns'] = intval( $cat_columns );
						}
						self::get_categories();
					}

				}

				if ( $offset > 0 ) {

					$curr_offset = $offset/$woocommerce_loop['columns'];
					$decimal = $curr_offset - (int) $curr_offset;

					if ( $decimal > 0 ) {
						$woocommerce_loop['loop'] = $decimal * $woocommerce_loop['columns'];
					}
					else {
						$woocommerce_loop['loop'] = 0;
					}

				}

				if ( is_ajax() ) {
					$remember = $_SERVER['REQUEST_URI'];
				}

				while ( $products->have_posts() ) : $products->the_post();

					if ( is_ajax() ) {
						$_SERVER['REQUEST_URI'] = esc_url( get_permalink() );
					}

					if ( $woocommerce_loop['columns'] !== self::$settings['columns'] ) {
						$woocommerce_loop['loop'] = 0;
					}
					$woocommerce_loop['columns'] = self::$settings['columns'];

					wc_get_template_part( 'content', 'product' );

				endwhile;

				if ( is_ajax() ) {
					$_SERVER['REQUEST_URI'] = $remember;
				}

				woocommerce_product_loop_end();

				if ( !empty( $loop_elements ) ) {
					self::make_visibility( 'add', $loop_elements );
				}

			}
			else {

				if ( is_ajax() ) {
					global $prdctfltr_global;
					$prdctfltr_global['preset'] = isset( $preset ) && $preset !== '' ? $preset : null;
					WC_Prdctfltr::prdctfltr_get_settings();
				}

				WC_Prdctfltr::$settings['template'] = 'loop/no-products-found.php';
				include( WC_Prdctfltr::$dir . 'templates/getright.php' );

			}

			return ob_get_clean();

		}

		public static function add_columns_filter() {
			return self::$settings['columns_ajax'];
		}

		public static function prdctfltr_sc_get_filter( $atts, $content = null ) {

			$shortcode_atts = shortcode_atts( array(
				'preset' => '',
				//'rows' => 4,
				'ajax' => 'no',
				'disable_overrides' => 'yes',
				//'disable_woo_filter' => 'no',
				'action' => '',
				'bot_margin' => 36,
				'class' => '',
				'shortcode_id' => ''
			), $atts );

			extract( $shortcode_atts );

			global $prdctfltr_global;

			$prdctfltr_global['sc_init'] = true;

			$paged = isset( $_GET['paged'] ) ? intval( $_GET['paged'] ) : get_query_var( 'paged' );

			if ( $paged < 1 ) {
				$paged = 1;
			}

			$prdctfltr_global['unique_id'] = uniqid( 'prdctfltr-' );
			$prdctfltr_global['action'] = ( $action !== '' ? $action : '' );
			$prdctfltr_global['preset'] = ( $preset !== '' ? $preset : '' );
			$prdctfltr_global['disable_overrides'] = ( $disable_overrides == 'yes' ? 'yes' : 'no' );

			$prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['query_args'] = array();
			$prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['atts'] = $shortcode_atts;
			$prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['args'] = array();
			$prdctfltr_global['pagefilters'][$prdctfltr_global['unique_id']]['request'] = array();

			if ( $ajax == 'yes' ) {
				$add_ajax = ' data-page="' . $paged . '"';
			}

			$bot_margin = ( int ) $bot_margin;
			$margin = " style='margin-bottom:" . $bot_margin . "px'";

			$opt = array(
				'pf_request' => array(),
				'pf_requested' => array(),
				'pf_filters' => array(),
				'pf_widget_title' => null,
				'pf_set' => 'archive',
				'pf_paged' => $paged,
				'pf_pagefilters' => array(),
				'pf_shortcode' => '',
				'pf_offset' => 0,
				'pf_restrict' => '',
				'pf_adds' => array(),
				'pf_orderby_template' => null,
				'pf_count_template' => null
			);

			self::$settings['opt'] = $opt;

			ob_start();

			include( WC_Prdctfltr::$dir . 'templates/product-filter.php' );

			$cached = ob_get_clean();

			$prdctfltr_global['unique_id'] = null;
			wp_reset_query();
			wp_reset_postdata();

			return '<div' . ( $shortcode_id !== '' ? ' id="' . $shortcode_id.'"' : '' ) . ' class="prdctfltr_sc prdctfltr_sc_filter woocommerce ' . ( $ajax == 'yes' ? ' prdctfltr_ajax' : '' ) . ( $class !== '' ? ' ' . $class : '' ) . '"' . $margin . ( $ajax == 'yes' ? $add_ajax : '' ) . '>' . do_shortcode( $cached ) . '</div>';

		}

		public static function make_visibility( $action = 'remove', $loop_elements = array() ) {

			if ( $action == 'remove' ) {

				if ( in_array( 'title', $loop_elements ) ) {
					remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
				}
				if ( in_array( 'rating', $loop_elements ) ) {
					remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
				}
				if ( in_array( 'price', $loop_elements ) ) {
					remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
				}
				if ( in_array( 'add_to_cart', $loop_elements ) ) {
					remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
				}

			}
			else if ( $action == 'add' ) {

				if ( in_array( 'title', $loop_elements ) ) {
					add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
				}
				if ( in_array( 'rating', $loop_elements ) ) {
					add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
				}
				if ( in_array( 'price', $loop_elements ) ) {
					add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
				}
				if ( in_array( 'add_to_cart', $loop_elements ) ) {
					add_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
				}

			}

		}

		public static function prdctfltr_wpml_language() {

			if ( isset( self::$settings['wpml_language'] ) ) {
				return self::$settings['wpml_language'];
			}
			else {
				if ( class_exists( 'SitePress' ) ) {
					global $sitepress;

					$default_language = $sitepress->get_default_language();
					$current_language = $sitepress->get_current_language();

					if ( $default_language != $current_language ) {
						$language = sanitize_title( $current_language );
						self::$settings['wpml_language'] = $language;
						return $language;
					}
					else {
						return false;
					}

				}
				else {
					return false;
				}
			}

		}

	}
	add_action( 'init', array( 'WC_Prdctfltr_Shortcodes', 'init' ), 999 );

?>